﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIRP.CRS.BO;

namespace VIRP.CRS.BLL {
    public static partial class FrameworkdataManager {
        #region Fields
        #endregion

        #region Constructors
        #endregion

        #region Properties
        #endregion

        #region Methods
        public static object GetFrameWorkInfo(string identity, int registryId, int referralId, int patientId, string frameworkTable)
        {
            object rslt = null;

            switch (frameworkTable.ToUpper())
            {
                case "ALLERGY":
                    rslt = ALLERGY_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "APPOINTMENTS":
                    rslt = APPOINTMENTS_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "AUDIOLOGY":
                    rslt = A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "CONSULT":
                    rslt = CONSULT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "EMERGENCY DEPARTMENT":
                    rslt = EDISLOG_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "ENCOUNTER":
                    rslt = ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                //case "FEE CPT MODIFIER":
                //    rslt = ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
                //    break;

                //case "FEE SERVICE PROVIDED":
                //    rslt = ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
                //    break;

                case "IMMUNIZATION":
                    rslt = IMMUNIZATION_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "INPATIENT":
                    rslt = INPAT_INPATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "INPATIENT - CENSUS":
                    rslt = INPAT_CENSUS_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "INPATIENTDIAGNOSIS":
                    rslt = INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "LAB SCREENING":
                    rslt = LABSCREENING_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "LABORATORY":
                    rslt = CHEM_LABCHEM_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "OUTPATIENT":
                    rslt = OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - CONSULT":
                    rslt = SCONSULT_REASON_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - ELIGIBILITY":
                    rslt = PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - ENROLLMENT":
                    rslt = PATIENT_ENROLLMENT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - ETHNICITY":
                    rslt = PATIENT_ETHNICITY_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - GEO CODED ADDRESS":
                    rslt = A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - INSURANCE":
                    rslt = SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - MILITARY SERVICE":
                    rslt = MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - MILITARY SEXUAL TRAUMA":
                    rslt = MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - OEF/OIF":
                    rslt = OEFOIF_SERVICE_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - PHARMACY":
                    rslt = PHARMACY_PATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - PROVIDER":
                    rslt = PATIENT_PROVIDER_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - RACE":
                    rslt = PATSUB_PATIENTRACE_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - RADIUM EXPOSURE":
                    rslt = NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - SERVICE CONNECTED CONDITION":
                    rslt = SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PATIENT - VA RATED DISABILITY":
                    rslt = PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PHARMACY - INPATIENT":
                    rslt = A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PHARMACY - INPATIENT UNIT DOSE":
                    rslt = A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PHARMACY - NON-VA":
                    rslt = A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PHARMACY - OUTPATIENT":
                    rslt = RXOUTPAT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PROBLEM LIST":
                    rslt = OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "PROGRESS NOTES":
                    rslt = TIU_TIUDOCUMENT_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "RADIOLOGY":
                    rslt = RADIOLOGYEXAM_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "SPATIENT":
                    rslt = SPATIENT_NEW_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "TRACER":
                    rslt = TRACER_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "VDIAGNOSIS":
                    rslt = OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;

                case "VITAL SIGN":
                    rslt = VITALSIGN_GET_BY_REFERRAL(identity, registryId, referralId);
                    break;
            }

            return rslt;
        }

        private static List<ENC_ENCOUNTER> ENC_ENCOUNTER_GET_BY_REFERRAL(string identity, int registryId, int referralId) {
            return VIRPManager.ENC_ENCOUNTER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<ALLERGY> ALLERGY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.ALLERGY_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<A06_AUDIOMETRIC_EXAM_DATA_509850_9> A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<CONSULT> CONSULT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.CONSULT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<EDISLOG> EDISLOG_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.EDISLOG_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<IMMUNIZATION> IMMUNIZATION_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.IMMUNIZATION_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<INPAT_INPATIENT> INPAT_INPATIENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPAT_INPATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<INPAT_CENSUS> INPAT_CENSUS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPAT_CENSUS_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<INPATIENT_DIAGNOSIS> INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<CHEM_LABCHEM> CHEM_LABCHEM_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.CHEM_LABCHEM_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_VISIT_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<SCONSULT_REASON> SCONSULT_REASON_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SCONSULT_REASON_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<PATSUB_SECONDARYELIGIBILITY> PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<PATIENT_ENROLLMENT> PATIENT_ENROLLMENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATIENT_ENROLLMENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<PATIENT_ETHNICITY> PATIENT_ETHNICITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATIENT_ETHNICITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<A06_SPATIENT_GEOCODEDADDRESS> A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<SPATIENT_SPATIENTINSURANCE> SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<MILITARY_SERVICE_EPISODE> MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<MILITARY_SEXUAL_TRAUMA> MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<OEFOIF_SERVICE> OEFOIF_SERVICE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OEFOIF_SERVICE_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<PHARMACY_PATIENT> PHARMACY_PATIENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PHARMACY_PATIENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<NOSETHROAT_RADIUMHST> NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<SERVICE_CONNECTED_CONDITION> SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<PATSUB_VARATEDDISABILITY> PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<A06_PHARMACY_PATIENT_55X_IV_55_01> A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<A06_PHARMACY_PATIX_UNIT_DOSE_55_06> A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<A06_PHARMACY_PATX_NONVA_MEDS_55_05> A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<RXOUTPAT> RXOUTPAT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.RXOUTPAT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<OUTPAT_PROBLEMLIST> OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<TIU_TIUDOCUMENT> TIU_TIUDOCUMENT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.TIU_TIUDOCUMENT_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<RADIOLOGYEXAM> RADIOLOGYEXAM_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.RADIOLOGYEXAM_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<SPATIENT_NEW> SPATIENT_NEW_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.SPATIENT_NEW_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<OUTPAT_VDIAGNOSIS> OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(identity, registryId, referralId);
        }
        
        private static List<VITALSIGN> VITALSIGN_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.VITALSIGN_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<PATSUB_PATIENTRACE> PATSUB_PATIENTRACE_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATSUB_PATIENTRACE_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<TRACER> TRACER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.TRACER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<LabScreening> LABSCREENING_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.LABSCREENING_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<APPT_APPOINTMENT> APPOINTMENTS_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.APPOINTMENTS_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        private static List<PATIENT_PROVIDER> PATIENT_PROVIDER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return VIRPManager.PATIENT_PROVIDER_GET_BY_REFERRAL(identity, registryId, referralId);
        }

        #endregion
    }
}
